SET TERM ^ ;

create or alter procedure PRO_ACERTA_DUPL_PARTE_MINERACAO
as
declare variable COD_DADOS integer;
declare variable SEQ_PARTESINT integer;
declare variable POSICAO_PARTESINT integer;
declare variable CODIGO_PARTESPROC_PARTESINT integer;
declare variable DATA_INC_PARTESINT date;
declare variable NOME_PARTESINT varchar(50);
declare variable SEQ_PARTES integer;
declare variable POSICAO_PARTES integer;
declare variable CODIGO_PARTESPOC_PARTES integer;
declare variable DATA_INC_PARTES date;
declare variable NOME_PARTES varchar(200);
begin
  for select distinct A.COD_DADOS, A.SEQ as SEQ_PARTESINT, A.POSICAO as POSICAO_PARTESINT,
                      A.CODIGO as CODIGO_PARTESPROC_PARTESINT, A.DATA_INC as DATA_INC_PARTESINT,
                      A.NOME as NOME_PARTESINT, B.SEQ as SEQ_PARTES, B.POSICAO as POSICAO_PARTES,
                      B.CODIGO as CODIGO_PARTESPOC_PARTES, B.DATA_INC as DATA_INC_PARTES, B.NOME as NOME_PARTES
      from (select PARTESPROC.COD_DADOS, PARTESPROC.SEQ, PARTESPROC.POSICAO, PARTESPROC.CODIGO, PARTESPROC.DATA_INC,
                   PARTESINT.NOME
            from PARTESPROC
            inner join PARTESINT on PARTESPROC.COD_PARTE = PARTESINT.CODIGO and partesproc.posicao = 0) A
      inner join(select PARTESPROC.COD_DADOS, PARTESPROC.SEQ, PARTESPROC.POSICAO, PARTESPROC.CODIGO,
                        PARTESPROC.DATA_INC, PARTES.NOME
                 from PARTESPROC
                 inner join PARTES on PARTESPROC.COD_PARTE = PARTES.CODIGO and partesproc.posicao = 1) B
            on A.NOME = SUBSTRING(B.NOME from 1 for 50) and
            A.COD_DADOS = B.COD_DADOS
      into :COD_DADOS, :SEQ_PARTESINT, :POSICAO_PARTESINT, :CODIGO_PARTESPROC_PARTESINT, :DATA_INC_PARTESINT,
           :NOME_PARTESINT, :SEQ_PARTES, :POSICAO_PARTES, :CODIGO_PARTESPOC_PARTES, :DATA_INC_PARTES, :NOME_PARTES
  do
  begin
    if ((:POSICAO_PARTESINT = 0) and
        (:SEQ_PARTESINT > 1)) then
    begin
      delete from PARTESPROC
      where PARTESPROC.CODIGO = :CODIGO_PARTESPROC_PARTESINT;
    end
    else
    if ((:POSICAO_PARTESINT = 0) and
        (:SEQ_PARTES > 1) and (:POSICAO_PARTES = 1)) then
    begin
      delete from PARTESPROC
      where PARTESPROC.CODIGO = :CODIGO_PARTESPOC_PARTES;
    end
  end
end^

SET TERM ; ^